*** Settings ***
Resource            /opt/robot-tests/tests/resources/common.resource
Library             /opt/robot-tests/tests/libraries/bodyRequests.py
Library             XML
Library             String
Resource            /opt/robot-tests/tests/resources/common/basicRequests.robot
Resource            ../../resources/common.resource
Resource            ../../resources/common/basicRequests.robot

Suite Teardown      Reset Testing Environment
Test Setup          Reset Testing Environment
Test Teardown       Reset Testing Environment


*** Variables ***
${API_INVOKER_NOT_REGISTERED}       not-valid
${SUBSCRIBER_ID_NOT_VALID}          not-valid
${SUBSCRIPTION_ID_NOT_VALID}        not-valid


*** Test Cases ***
Invoker subscribe to Service API Available
    [Tags]    pelayo-1    mockserver

    # Initialize Mock server
    Init Mock Server

    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    # Create Provider1 with 2 AEF roles and publish API
    ${register_user_info_provider_1}=    Provider Default Registration
    ${aef_id_1}=    Set Variable    ${register_user_info_provider_1['aef_roles']['${AEF_PROVIDER_USERNAME}']['aef_id']}
    ${aef_empty_list}=    Create List

    # Subscribe to events and setup event filter with api_id
    ${events_list}=    Create List    API_INVOKER_ONBOARDED
    ${event_req}=    Create Event Req    notif_method=PERIODIC   max_report_nbr=${2}   rep_period=${1}

    ${subscription_ids}=   Create List

    FOR    ${counter}    IN RANGE    1    10000    1
        Log    ${counter}
        ${subscription_id}=
        ...    Subscribe invoker ${register_user_info_invoker} to events ${events_list} with event req ${event_req}
        Append To List    ${subscription_ids}   ${subscription_id}
    END

    Sleep     300s

    ${resp}=    Get Mock Server Messages

    ${notification_events_on_mock_server}=    Set Variable    ${resp.json()}

Invoker subscribe to Service API Availables
    [Tags]    event_filter-7    mockserver    smoke

    # Initialize Mock server
    Init Mock Server

    # Register Providers
    ## Default Provider 1 Registration
    ${register_user_info_provider_1}=    Provider Default Registration    provider_username=${PROVIDER_USERNAME}_1
    ${aef_id_1}=    Set Variable
    ...    ${register_user_info_provider_1['aef_roles']['${AEF_PROVIDER_USERNAME}_1']['aef_id']}

    ## Publish service_1 API
    ${service_api_description_published_1}
    ...    ${provider_resource_url_1}
    ...    ${provider_request_body_1}=
    ...    Publish Service Api
    ...    ${register_user_info_provider_1}
    ...    service_name=service_1

    ## Default Provider 2 Registration
    ${register_user_info_provider_2}=    Provider Default Registration    provider_username=${PROVIDER_USERNAME}_2
    ${aef_id_2}=    Set Variable
    ...    ${register_user_info_provider_2['aef_roles']['${AEF_PROVIDER_USERNAME}_2']['aef_id']}

    ## Publish service_2 API
    ${service_api_description_published_2}
    ...    ${provider_resource_url_2}
    ...    ${provider_request_body_2}=
    ...    Publish Service Api
    ...    ${register_user_info_provider_2}
    ...    service_name=service_2

    ## Store apiId1 and apiId2 for further use
    ${service_api_id_1}=    Set Variable    ${service_api_description_published_1['apiId']}
    ${service_api_id_2}=    Set Variable    ${service_api_description_published_2['apiId']}

    # Register Invokers
    ## Default Invoker 1 Registration and Onboarding
    ${register_user_info_invoker_1}    ${invoker_url_1}    ${request_body_1}=    Invoker Default Onboarding
    ...    invoker_username=${INVOKER_USERNAME}_1

    ## Default Invoker 2 Registration and Onboarding
    ${register_user_info_invoker_2}    ${invoker_url_2}    ${request_body_2}=    Invoker Default Onboarding
    ...    invoke_username=${INVOKER_USERNAME}_2

    ## Store apiInvokerIds for further use
    ${api_invoker_id_1}=    Set Variable    ${register_user_info_invoker_1['api_invoker_id']}
    ${api_invoker_id_2}=    Set Variable    ${register_user_info_invoker_2['api_invoker_id']}

    # Subscribe to events
    ## Event lists
    ${events_list}=    Create List    SERVICE_API_INVOCATION_SUCCESS    SERVICE_API_INVOCATION_FAILURE

    ## Event filters
    ${event_filter_empty}=    Create Capif Event Filter
    ${event_filter_api_invoker_ids}=    Create Capif Event Filter    apiInvokerIds=${api_invoker_id_1}
    ${event_filter_api_ids}=    Create Capif Event Filter    apiIds=${service_api_id_1}
    ${event_filter_aef_ids}=    Create Capif Event Filter    aefIds=${aef_id_2}
    ${event_filter_api_ids_and_aef_ids}=    Create Capif Event Filter
    ...    apiIds=${service_api_id_2}
    ...    aefIds=${aef_id_2}
    ${event_filter_api_ids_and_api_invoker_ids}=    Create Capif Event Filter
    ...    apiInvokerIds=${api_invoker_id_2}
    ...    apiIds=${service_api_id_2}
    ${event_filter_aef_ids_and_api_invoker_ids}=    Create Capif Event Filter
    ...    apiInvokerIds=${api_invoker_id_2}
    ...    aefIds=${aef_id_1}
    ${event_filter_api_ids_aef_ids_and_api_invoker_ids}=    Create Capif Event Filter
    ...    apiInvokerIds=${api_invoker_id_2}
    ...    aefIds=${aef_id_2}
    ...    apiIds=${service_api_id_2}

    ## Subscription to Events 1
    ${event_filters}=    Create List    ${event_filter_api_ids}    ${event_filter_api_ids}
    ${subscription_id_1}=
    ...    Subscribe provider ${register_user_info_provider_1} to events ${events_list} with event filters ${event_filters}

    ## Subscription to Events 2
    ${event_filters}=    Create List    ${event_filter_aef_ids}    ${event_filter_aef_ids}
    ${subscription_id_2}=
    ...    Subscribe provider ${register_user_info_provider_1} to events ${events_list} with event filters ${event_filters}

    ## Subscription to Events 3
    ${event_filters}=    Create List    ${event_filter_api_invoker_ids}    ${event_filter_api_invoker_ids}
    ${subscription_id_3}=
    ...    Subscribe provider ${register_user_info_provider_1} to events ${events_list} with event filters ${event_filters}

    ## Subscription to Events 4
    ${event_filters}=    Create List    ${event_filter_api_ids_and_aef_ids}    ${event_filter_api_ids_and_aef_ids}
    ${subscription_id_4}=
    ...    Subscribe provider ${register_user_info_provider_1} to events ${events_list} with event filters ${event_filters}

    ## Subscription to Events 5
    ${event_filters}=    Create List
    ...    ${event_filter_api_ids_and_api_invoker_ids}
    ...    ${event_filter_api_ids_and_api_invoker_ids}
    ${subscription_id_5}=
    ...    Subscribe provider ${register_user_info_provider_1} to events ${events_list} with event filters ${event_filters}

    ## Subscription to Events 6
    ${event_filters}=    Create List
    ...    ${event_filter_aef_ids_and_api_invoker_ids}
    ...    ${event_filter_aef_ids_and_api_invoker_ids}
    ${subscription_id_6}=
    ...    Subscribe provider ${register_user_info_provider_1} to events ${events_list} with event filters ${event_filters}

    ## Subscription to Events 7
    ${event_filters}=    Create List
    ...    ${event_filter_api_ids_aef_ids_and_api_invoker_ids}
    ...    ${event_filter_api_ids_aef_ids_and_api_invoker_ids}
    ${subscription_id_7}=
    ...    Subscribe provider ${register_user_info_provider_1} to events ${events_list} with event filters ${event_filters}

    # 1.Log entry for service_1 and invoker_1
    ${request_body_log_1}=    Send Log Message to CAPIF
    ...    ${service_api_id_1}
    ...    service_1
    ...    ${register_user_info_invoker_1}
    ...    ${register_user_info_provider_1}
    ...    200
    ...    400

    # 2.Log entry for service_2 and invoker_1
    ${request_body_log_2}=    Send Log Message to CAPIF
    ...    ${service_api_id_2}
    ...    service_2
    ...    ${register_user_info_invoker_1}
    ...    ${register_user_info_provider_2}
    ...    200

    # 3.Log entry for service_2 and invoker_2
    ${request_body_log_3}=    Send Log Message to CAPIF
    ...    ${service_api_id_2}
    ...    service_2
    ...    ${register_user_info_invoker_2}
    ...    ${register_user_info_provider_2}
    ...    200

    # 4.Log entry for service_1 and invoker_2
    ${request_body_log_4}=    Send Log Message to CAPIF
    ...    ${service_api_id_1}
    ...    service_1
    ...    ${register_user_info_invoker_2}
    ...    ${register_user_info_provider_1}
    ...    400

    # Check Event Notifications
    ## Create check Events to ensure all notifications were received
    ### Subscription 1 Checks
    ${events_expected}=    Create Events From InvocationLogs
    ...    ${subscription_id_1}
    ...    ${request_body_log_1}

    ${events_expected}=    Create Events From InvocationLogs
    ...    ${subscription_id_1}
    ...    ${request_body_log_4}
    ...    events_expected=${events_expected}

    ### Subcription 2 Checks
    ${events_expected}=    Create Events From InvocationLogs
    ...    ${subscription_id_2}
    ...    ${request_body_log_2}
    ...    events_expected=${events_expected}

    ${events_expected}=    Create Events From InvocationLogs
    ...    ${subscription_id_2}
    ...    ${request_body_log_3}
    ...    events_expected=${events_expected}

    # Subscription 3 Checks
    ${events_expected}=    Create Events From InvocationLogs
    ...    ${subscription_id_3}
    ...    ${request_body_log_1}
    ...    events_expected=${events_expected}

    ${events_expected}=    Create Events From InvocationLogs
    ...    ${subscription_id_3}
    ...    ${request_body_log_2}
    ...    events_expected=${events_expected}

    # Subscription 4 Checks
    ${events_expected}=    Create Events From InvocationLogs
    ...    ${subscription_id_4}
    ...    ${request_body_log_2}
    ...    events_expected=${events_expected}

    ${events_expected}=    Create Events From InvocationLogs
    ...    ${subscription_id_4}
    ...    ${request_body_log_3}
    ...    events_expected=${events_expected}

    # Subscription 5 Checks
    ${events_expected}=    Create Events From InvocationLogs
    ...    ${subscription_id_5}
    ...    ${request_body_log_3}
    ...    events_expected=${events_expected}

    # Subscription 6 Checks
    ${events_expected}=    Create Events From InvocationLogs
    ...    ${subscription_id_6}
    ...    ${request_body_log_4}
    ...    events_expected=${events_expected}

    # Subscription 7 Checks
    ${events_expected}=    Create Events From InvocationLogs
    ...    ${subscription_id_7}
    ...    ${request_body_log_3}
    ...    events_expected=${events_expected}

    Log List    ${events_expected}
    ## Check Events Expected towards received notifications at mock server
    Wait Until Keyword Succeeds    5x    5s    Check Mock Server Notification Events    ${events_expected}


*** Keywords ***
Create Security Context between ${invoker_info} and ${provider_info}
    # Discover APIs by invoker
    ${discover_response}=    Get Request Capif
    ...    ${DISCOVER_URL}${invoker_info['api_invoker_id']}&aef-id=${provider_info['aef_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${invoker_info['management_cert']}

    Check Response Variable Type And Values    ${discover_response}    200    DiscoveredAPIs

    # create Security Context
    ${request_service_security_body}    ${api_ids}=    Create Service Security From Discover Response
    ...    http://${CAPIF_HOSTNAME}:${CAPIF_HTTP_PORT}/test
    ...    ${discover_response}
    ...    legacy=${FALSE}
    ${resp}=    Put Request Capif
    ...    /capif-security/v1/trustedInvokers/${invoker_info['api_invoker_id']}
    ...    json=${request_service_security_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${invoker_info['management_cert']}

    Set To Dictionary    ${invoker_info}    security_body=${request_service_security_body}
    # Check Service Security
    Check Response Variable Type And Values    ${resp}    201    ServiceSecurity
    ${resource_url}=    Check Location Header    ${resp}    ${LOCATION_SECURITY_RESOURCE_REGEX}

    ${api_invoker_policies_list}=    Create List

    FOR    ${api_id}    IN    @{api_ids}
        Log    ${api_id}
        ${resp}=    Get Request Capif
        ...    /access-control-policy/v1/accessControlPolicyList/${api_id}?aef-id=${provider_info['aef_id']}
        ...    server=${CAPIF_HTTPS_URL}
        ...    verify=ca.crt
        ...    username=${provider_info['aef_username']}
        Check Response Variable Type And Values    ${resp}    200    AccessControlPolicyList
        Should Not Be Empty    ${resp.json()['apiInvokerPolicies']}
        ${api_invoker_policies}=    Set Variable    ${resp.json()['apiInvokerPolicies']}
        ${api_invoker_policies_list}=    Set Variable    ${api_invoker_policies}
    END

    Log List    ${api_invoker_policies_list}

    RETURN    ${api_invoker_policies_list}

Update Security Context between ${invoker_info} and ${provider_info}
    # Discover APIs by invoker
    ${discover_response}=    Get Request Capif
    ...    ${DISCOVER_URL}${invoker_info['api_invoker_id']}&aef-id=${provider_info['aef_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${invoker_info['management_cert']}

    Check Response Variable Type And Values    ${discover_response}    200    DiscoveredAPIs

    # create Security Context
    ${request_service_security_body}    ${api_ids}=    Update Service Security With Discover Response
    ...    ${invoker_info['security_body']}
    ...    ${discover_response}
    ...    legacy=${FALSE}
    ${resp}=    Post Request Capif
    ...    /capif-security/v1/trustedInvokers/${invoker_info['api_invoker_id']}/update
    ...    json=${request_service_security_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${invoker_info['management_cert']}

    # Check Service Security
    Check Response Variable Type And Values    ${resp}    200    ServiceSecurity
    ${resource_url}=    Check Location Header    ${resp}    ${LOCATION_SECURITY_RESOURCE_REGEX}

    ${api_invoker_policies_list}=    Create List

    ${api_id}=    Get From List    ${api_ids}    -1
    Log    ${api_id}
    ${resp}=    Get Request Capif
    ...    /access-control-policy/v1/accessControlPolicyList/${api_id}?aef-id=${provider_info['aef_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${provider_info['aef_username']}

    Check Response Variable Type And Values    ${resp}    200    AccessControlPolicyList
    # Check returned values
    Should Not Be Empty    ${resp.json()['apiInvokerPolicies']}

    ${api_invoker_policies}=    Set Variable    ${resp.json()['apiInvokerPolicies']}
    # Append To List    ${api_invoker_policies_list}    ${api_invoker_policies}
    ${api_invoker_policies_list}=    Set Variable    ${api_invoker_policies}

    Log List    ${api_invoker_policies_list}

    RETURN    ${api_invoker_policies_list}

Subscribe provider ${provider_info} to events ${events_list} with event filters ${event_filters}
    ${resp}=
    ...    Subscribe ${provider_info['amf_id']} with ${provider_info['amf_username']} to ${events_list} with ${event_filters}

    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    RETURN    ${subscription_id}

Subscribe invoker ${invoker_info} to events ${events_list} with event filters ${event_filters}
    ${resp}=
    ...    Subscribe ${invoker_info['api_invoker_id']} with ${invoker_info['management_cert']} to ${events_list} with ${event_filters}

    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    RETURN    ${subscription_id}

Subscribe invoker ${invoker_info} to events ${events_list} with event req ${event_req}
    ${resp}=
    ...    Subscribe ${invoker_info['api_invoker_id']} with ${invoker_info['management_cert']} to ${events_list} with ${event_req}

    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    RETURN    ${subscription_id}

Subscribe ${subscriber_id} with ${username} to ${events_list} with ${event_req}
    ${request_body}=    Create Events Subscription
    ...    events=@{events_list}
    ...    notification_destination=${NOTIFICATION_DESTINATION_URL}/testing
    ...    supported_features=C
    ...    event_req=${event_req}
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${subscriber_id}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${username}

    RETURN    ${resp}

Send Log Message to CAPIF
    [Arguments]    ${api_id}    ${service_name}    ${invoker_info}    ${provider_info}    @{results}
    ${api_ids}=    Create List    ${api_id}
    ${api_names}=    Create List    ${service_name}
    ${request_body}=    Create Log Entry
    ...    ${provider_info['aef_id']}
    ...    ${invoker_info['api_invoker_id']}
    ...    ${api_ids}
    ...    ${api_names}
    ...    results=@{results}
    ${resp}=    Post Request Capif
    ...    /api-invocation-logs/v1/${provider_info['aef_id']}/logs
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${provider_info['amf_username']}

    Check Response Variable Type And Values    ${resp}    201    InvocationLog
    ${resource_url}=    Check Location Header    ${resp}    ${LOCATION_LOGGING_RESOURCE_REGEX}

    RETURN    ${request_body}

Check not valid ${resp} with event filter ${attribute_snake_case} for event ${event}
    # Check Results
    ${invalid_param}=    Create Dictionary
    ...    param=eventFilter
    ...    reason=The eventFilter {'${attribute_snake_case}'} for event ${event} are not applicable.
    ${invalid_param_list}=    Create List    ${invalid_param}
    Check Response Variable Type And Values
    ...    ${resp}
    ...    400
    ...    ProblemDetails
    ...    title=Bad Request
    ...    status=400
    ...    detail=Bad Param
    ...    cause=Invalid eventFilter for event ${event}
    ...    invalidParams=${invalid_param_list}
